import {headers} from './payload.js';
import { cloneDeep } from 'lodash';

const HOST = 'https://dash.applovin.com';
const MEDIATION = HOST + '/mediation';


const TOKEN = {
    ID: null,
    NAME: '__Host-CSRF',
};

const NETWORK_TYPES = {
    ADMOB_NETWORK: 'ADMOB_NETWORK',
    AMAZON_MARKETPLACE_NETWORK: 'AMAZON_MARKETPLACE_NETWORK',
    APPLOVIN_NETWORK: 'APPLOVIN_NETWORK',
    APPLOVIN_EXCHANGE: 'APPLOVIN_EXCHANGE',
    BIDMACHINE_BIDDING: 'BIDMACHINE_BIDDING',
    BIGO_BIDDING: 'BIGO_BIDDING',
    CHARTBOOST_BIDDING: 'CHARTBOOST_BIDDING',
    CSJ_NETWORK: 'CSJ_NETWORK',
    FACEBOOK_NETWORK: 'FACEBOOK_NETWORK',
    FYBER_BIDDING: 'FYBER_BIDDING',
    GOOGLE_AD_MANAGER_NETWORK: 'GOOGLE_AD_MANAGER_NETWORK',
    HYPRMX_NETWORK: 'HYPRMX_NETWORK',
    INMOBI_BIDDING: 'INMOBI_BIDDING',
    IRONSOURCE_BIDDING: 'IRONSOURCE_BIDDING',
    LINE_NETWORK: 'LINE_NETWORK',
    LINE_BIDDING: 'LINE_BIDDING',
    MAIO_NETWORK: 'MAIO_NETWORK',
    MINTEGRAL_BIDDING: 'MINTEGRAL_BIDDING',
    MOBILEFUSE_BIDDING: 'MOBILEFUSE_BIDDING',
    MOLOCO_BIDDING: 'MOLOCO_BIDDING',
    MYTARGET_BIDDING: 'MYTARGET_BIDDING',
    OGURY_PRESAGE_BIDDING: 'OGURY_PRESAGE_BIDDING',
    PUBMATIC_BIDDING: 'PUBMATIC_BIDDING',
    SMAATO_BIDDING: 'SMAATO_BIDDING',
    TENCENT_NETWORK: 'TENCENT_NETWORK',
    TIKTOK_BIDDING: 'TIKTOK_BIDDING',
    UNITY_BIDDING: 'UNITY_BIDDING',
    VERVE_BIDDING: 'VERVE_BIDDING',
    VUNGLE_BIDDING: 'VUNGLE_BIDDING',
    YANDEX_BIDDING: 'YANDEX_BIDDING',
    YSO_BIDDING: 'YSO_BIDDING',
    CUSTOM_NETWORK_SDK: 'CUSTOM_NETWORK_SDK',
}

const AD_TYPE = {
    BANNER: 'BANNER',
    INTER: 'INTER',
    MREC: 'MREC',
    NATIVE: 'NATIVE',
    REWARDED: 'REWARD',
}

const state = {
    userId: null,
    adType: document.getElementById('adType'),
    platform: document.getElementById('platform'),
    adUnitSelect: document.getElementById('adUnitSelect'),
    adUnitSearchInput: document.getElementById('adUnitSearchInput'),
    typeCustomNetwork: document.getElementById('typeCustomNetwork'),
    priceFlorFrom: document.getElementById('priceFlorFrom'),
    priceFlorTo: document.getElementById('priceFlorTo'),
    // placementParams: document.getElementById('placementParams'),
    countryTargetingType: document.getElementById('countryTargetingType'),
    adUnitCollection: [],
    adUnitCurrent: null,
    staticNetworkPlacementSpec: {
        networkZoneId: '',
        extraParameters: {
            customParameters: {
                unicorn: true,
                ecpm: null,
            }
        },
        disabled: false,
        isAutoCpmEnabled: false,
        bidFloorSpec: {
            disabled: false,
            bidFloor: null,
            countryTargetingType: 'COUNTRY_TARGETING_INCLUDE',
            countries: [],
            excludedCountries: []
        },
        autoCpmReportLink: '/o/mediation/report#rsid=b8805181de7056637baeafbf07405175f16c5608',
        refreshIntervalSec: 0
    },
};

const preloader = document.getElementById('preloader');
const errorBlock = document.getElementById('error');
const successBlock = document.getElementById('success');

// ------- Global blocks -----------
const first = document.getElementById('first');
const second = document.getElementById('second');
const third = document.getElementById('third');

document.addEventListener('DOMContentLoaded', () => {
    showPreloader();
    getToken();
    getCurrentUser().then(r => {
        console.log('Gotten user id: ', r, 'user id in state: ', state.userId);
    });
});

function showPreloader() {
    hideError();
    preloader.classList.remove('hide');
}
function hidePreloader() {
    preloader.classList.add('hide');
}

function showError(e) {
    errorBlock.classList.remove('hide');
    hidePreloader();
    console.error(e);
}
function hideError() {
    errorBlock.classList.add('hide');
}

function showSuccess() {
    // create title
    const title = document.createElement('h3');
    title.innerText = 'Congratulations!';

    // create some text
    const text = document.createElement('p');
    const parts = ['You can go to this', ' ', 'and see the updated list of placements or just close this modal.'];
    text.appendChild(document.createTextNode(parts[0] + ' '));
    text.appendChild(document.createTextNode(parts[1] + ' '));

    const link = document.createElement('a');
    link.setAttribute('href', `${MEDIATION}/ad_units/edit/${state.userId}/${state.adUnitSelect.value}`);
    link.setAttribute('target', `_blank`);
    link.innerText = 'AdUnit';

    text.appendChild(link);
    text.appendChild(document.createTextNode(' ' + parts[2]));


    // create Close btn
    const button = document.createElement('button')
    button.innerText = 'Cancel';
    button.setAttribute('type', 'button');
    button.classList.add('button', 'button--cancel');


    successBlock.appendChild(title);
    successBlock.appendChild(text);
    successBlock.appendChild(button);

    successBlock.classList.remove('hide');
}

function showSecond() {
    first.classList.add('hide');
    second.classList.remove('hide');
}
function showThird() {
    second.classList.add('hide');
    third.classList.remove('hide');
}

function getCurrentUser() {
    return fetchCurrentUserId()
        .then(data => {
            console.log(data, 'Getting user id');
            state.userId = data.user.id;
            return data.user.id;
        });
}
function fetchCurrentUserId() {
    return fetcher(`${HOST}/intel/v1/users/me`);
}


// --------------- Transfer to the api module -----------------
function responseHandler(response) {
    if (response.ok) {
        hidePreloader(); // -----> ???
        return response.json();
    }

    throw new Error('Network response was not ok');
}
function rejectHandler(error) {
    console.error('Something went wrong', error);
    showError();
}
function fetcher(url) {
    return fetch(url, {
        "headers": {
            ...headers,
            "api-version": "3.3",
            "x-csrf-token": TOKEN.ID,
        },
        "referrerPolicy": "strict-origin-when-cross-origin",
        "method": "GET",
        "mode": "cors",
        "credentials": "include"
    })
        .then(responseHandler)
        .catch(rejectHandler);
}
function fetcherPOST(url, referrer, payload) {
    return fetch(url, {
        "headers": {
            ...headers,
            "api-version": "3.3",
            "x-csrf-token": TOKEN.ID,
        },
        referrer,
        "referrerPolicy": "strict-origin-when-cross-origin",
        body: JSON.stringify(payload),
        "method": "POST",
        "mode": "cors",
        "credentials": "include"
    })
        .then(responseHandler)
        .catch(rejectHandler);
}

// For example ---> '__Host-CSRF: x9fz4WD5eo5+iqDBk4mC1A9CoGY0qh0pX+FESwJHMjMRQOdP'
function getCookie(name) {
    const cookieString = document.cookie;
    debugger;
    if (!cookieString) {
        return null;
    }

    let collection = new Map();
    cookieString.split(';').forEach(cookie => {
        const [key, value] = cookie.trim().split('=');
        const newValue = value.replace(/%2B/g, '+');
        collection.set(key, newValue);
    });

    return collection.has(name) ? collection.get(name) : null;
}

function getToken() {
    chrome.tabs.query(
        {active: true, currentWindow: true},
        function(tabs) {
            const tab = tabs[0];
            const url = tab.url;

            chrome.cookies.getAll({url: url}, function(cookies) {
                let cookie = cookies.find(cookie => cookie.name === TOKEN.NAME).value;
                TOKEN.ID = decodeURIComponent(cookie);
                console.log('Token:', TOKEN);
            });
        }
    );
}



// AdUnit List. First Screen
document.getElementById('getAdUnitListAction').addEventListener('click', res => {
    showPreloader();
    getAdUnitCollections();
});
function getAdUnitCollections() {
    fetchAdUnitCollections()
        .then(data => {
            console.log(data, 'Getting AdUnit Collections');
            // hide First screen and show second with list
            state.adUnitCollection = cloneDeep(data.adUnitCollections);
            let sortCollection = state.adUnitCollection.sort((a, b) => {
                let first = a.displayName.toLowerCase();
                let second = b.displayName.toLowerCase();

                if (first < second) {
                    return -1;
                }
                if (first > second) {
                    return 1;
                }
                return 0;
            });
            buildAdUnitOptionHTML(sortCollection);
            searchAdUnit();
            showSecond();
        })
}
function fetchAdUnitCollections() {
    console.log("Start fetch AdUnit Collections", state);

    let userId = state.userId; // 369699;
    let adType = state.adType.value;
    let platform = state.platform.value;

    const url = `${MEDIATION}/v2/clone_ad_units/${userId}?adFormat=${adType}&platform=${platform}`
    return fetcher(url);
}
function buildAdUnitOptionHTML(collection) {
    state.adUnitSelect.innerHTML = collection.reduce((prev, cur) => {
        let item = `<option value="${cur.adUnits[0].id}">${cur.displayName}</option>`
        return prev + item;
    }, '');
}

function searchAdUnit() {
    state.adUnitSearchInput.addEventListener('input', function() {
        const filter = this.value.toLowerCase();
        const options = state.adUnitSelect.options;

        let count = 0;
        for (let i = 0; i < options.length; i++) {
            const optionText = options[i].text.toLowerCase();
            if (optionText.includes(filter)) {
                count++;
                options[i].style.display = '';
            } else {
                options[i].style.display = 'none';
            }
        }

        state.adUnitSelect.disabled = count === 0;
    });
}





// Choose AdUnit. Second Screen
document.getElementById('secondScreenAction').addEventListener('click', res => {
    showPreloader();
    fetchSelectedAdUnit()
        .then(resp => {
            state.adUnitCurrent = cloneDeep(resp.adUnitCollection);
            buildCustomNetworkOptionHTML(state.adUnitCurrent.adUnits[0].networkSpecs);
            showThird();
        });
});
function fetchSelectedAdUnit() {
    console.log("Starting to create placements", state);

    const url = `${MEDIATION}/v2/ad_unit/${state.userId}/${state.adUnitSelect.value}`;
    return fetcher(url);
}
function buildCustomNetworkOptionHTML(collection) {
    state.typeCustomNetwork.innerHTML = collection.reduce((prev, cur) => {
        if (cur.networkType !== NETWORK_TYPES.CUSTOM_NETWORK_SDK) {
            return prev;
        }

        let networkName = cur.extraParameters.customNetworkSpec.networkName;
        let item = `<option value="${networkName}">Custom Network - ${networkName}</option>`
        return prev + item;
    }, '');
}









// Setup AdUnit and create items
document.getElementById('createItemsAction').addEventListener('click', res => {
    showPreloader();
    buildNetworkPlacements().then(resp => {
        console.log(resp, 'Placements are created!');

        if (resp.adUnitCollectionSaveResponse) {
            // тут нужно проверить
            showSuccess();
        }

        if (resp.errorMessage) {
            showError();
        }
    });
});
function buildNetworkPlacements() {
    const payload = state.adUnitCurrent;

    const defaultAdUnit = payload.adUnits[0];
    const selectedCustomNetwork = defaultAdUnit.networkSpecs.find((spec) => {
        if (spec.networkType !== NETWORK_TYPES.CUSTOM_NETWORK_SDK) {
            return false;
        }

        if (spec.extraParameters && Object.keys(spec.extraParameters).length > 0) {
            return spec.extraParameters.customNetworkSpec.networkName.toLowerCase() === state.typeCustomNetwork.value.toLowerCase();
        }
    });

    if (!selectedCustomNetwork) {
        console.warn(`Nothing to find! The list of networkSpecs was empty or not found!`);
        return;
    }


    // если пустые поля - добавить валидацию
    // уведомление если выбрали COUNTRY_TARGETING_EXCLUDE

    let from = state.priceFlorFrom.value;
    let to = state.priceFlorTo.value;

    let steps = buildSteps(state.adType.value);
    const updSteps = steps.map((step, idx) => {
        if (from > step.start && from > step.end) {
            console.warn(1);
            return;
        }

        if (from > step.start && from < step.end && to > step.end) {
            console.warn(2);
            step.start = Number(from);
            return step
        }

        if (step.start <= to && to < step.end) {
            console.warn(4);
            step.end = Number(to);
            return step;
        }


        if (step.start > to && step.end > to) {
            return;
        }

        return step;
    }).filter(Boolean);

    updSteps.forEach(({start, end, step, type}) => {
        for (let i = Number(start); i <= Number(end); i += Number(step)) {
            placement(
                selectedCustomNetwork.networkPlacementSpecs,
                i,
                type,
                isUnicornPlacement(state.adType.value, i)
            );
        }
    });

    // uncomment this line for clearing list network
    // selectedCustomNetwork.networkPlacementSpecs.splice(0, selectedCustomNetwork.networkPlacementSpecs.length);

    selectedCustomNetwork.networkPlacementSpecs.forEach(spec => (spec.disabled = false));
    if (selectedCustomNetwork.disabled) {
        selectedCustomNetwork.disabled = false;
    }

    return createNetworkPlacements(payload);
}
function createNetworkPlacements(payload) {
    console.log("Starting to create placements", state);

    const url = `${MEDIATION}/v2/ad_unit/${state.userId}`;
    const referrer = `${MEDIATION}/ad_units/edit/${state.userId}/${state.adUnitSelect.value}`;
    return fetcherPOST(url, referrer, payload);
}

function buildSteps(format, start, end) {
    switch (format) {
        case AD_TYPE.BANNER:
        case AD_TYPE.MREC:
            return [
                { start: 0.01, end: 0.09, step: 0.01, type: 'float'},
                { start: 0.1, end: 0.9, step: 0.05, type: 'float'},
                { start: 1, end: 2, step: 0.1, type: 'float'},
                { start: 2, end: 9, step: 0.5, type: 'float'},
                { start: 10, end: 19, step: 1, type: 'int'},
                { start: 20, end: 29, step: 2, type: 'int'},
                { start: 30, end: 50, step: 5, type: 'int'},
            ];
        case AD_TYPE.INTER:
        case AD_TYPE.REWARDED:
            return [
                { start: 1, end: 49, step: 1, type: 'int'},
                { start: 50, end: 99, step: 5, type: 'int'},
                { start: 100, end: 199, step: 10, type: 'int'},
                { start: 200, end: 500, step: 50, type: 'int'},
            ];
        default:
            return [
                { start, end, step: 1, type: 'int'}
            ]
    }
}
function isUnicornPlacement(adType, value) {
    switch (adType) {
        case AD_TYPE.BANNER:
            return value === 50;
        case AD_TYPE.INTER:
        case AD_TYPE.REWARDED:
            return value === 500;
        default:
            return false
    }
}

function placement(specs, i, type, unicorn) {
    try {
        let value = type === 'float' ? Number(i.toFixed(3)) : Number(i);

        let placement = cloneDeep(
            specs.length === 0
                ? state.staticNetworkPlacementSpec
                : specs[0])
        ;

        placement.disabled = false;
        placement.networkZoneId = `bidon_${value}`;
        placement.bidFloorSpec = {
            disabled: false,
            bidFloor: value,
            countryTargetingType: state.countryTargetingType.value,
            countries: [],
            excludedCountries: []
        }

        // remove unused params
        const keys = Object.keys(placement.extraParameters.customParameters);
        for (const key of keys) {
            delete placement.extraParameters.customParameters[key];
        }

        placement.extraParameters.customParameters.ecpm = value;

        if (unicorn) {
            placement.extraParameters.customParameters.unicorn = true;
            placement.extraParameters.customParameters.auction_key = '';
            placement.extraParameters.customParameters.pricefloor_coef = '';
            placement.extraParameters.customParameters.pricefloor_start = '';
        }

        if (specs.findIndex(item => item.bidFloorSpec.bidFloor === placement.bidFloorSpec.bidFloor) === -1) {
            specs.push(placement);
        }

        return specs;
    } catch (error) {
        showError(error);
    }
}


document.querySelectorAll('.close').forEach(el => {
    el.addEventListener('click', function() {
        window.close();
    });
});
