const path = require('path');
const HtmlWebpackPlugin = require('html-webpack-plugin');
const MiniCssExtractPlugin = require('mini-css-extract-plugin');

module.exports = {
    entry: ['./src/index.js', './src/styles.js'], // входной файл
    output: {
        filename: 'bundle.js',
        path: path.resolve(__dirname, 'dist'), // папка для сборки
        clean: true // очищать dist перед сборкой
    },
    module: {
        rules: [
            {
                test: /\.js$/i,
                exclude: /node_modules/,
                use: {
                    loader: 'babel-loader',
                    options: {
                        presets: ['@babel/preset-env']
                    }
                }
            },
            {
                test: /\.scss$/i,
                use: [
                    MiniCssExtractPlugin.loader, // извлекает CSS в отдельный файл
                    'css-loader',               // интерпретирует @import и url()
                    'sass-loader',              // компилирует Sass в CSS
                ],
            },
            {
                test: /\.html$/i,
                loader: 'html-loader' // для импортирования HTML
            }
        ]
    },
    plugins: [
        new HtmlWebpackPlugin({
            template: './src/index.html' // шаблон HTML
        }),
        new MiniCssExtractPlugin({
            filename: 'styles.css', // имя файла со стилями
        }),
    ],
    devServer: {
        static: './src',
        hot: true
    }
};
